<?php

declare(strict_types=1);

namespace App\Controller\Portal\Magazine\Article;

use App\Entity\Magazine\Article\Article;
use App\Repository\Magazine\Article\ArticleRepository;
use App\Service\View\ViewHandlerInterface;
use App\Transformer\DTO\Article\ArticleDetailsTransformer;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;

#[Route(path: '/magazine/articles/{slug}', name: 'magazine_article_view', methods: ['GET'])]
final class ViewController extends AbstractController
{
    public function __construct(
        private readonly ArticleRepository         $articleRepository,
        private readonly ArticleDetailsTransformer $articleDetailsTransformer,
        private readonly ViewHandlerInterface      $viewHandler,
    )
    {
    }

    public function __invoke(Request $request, string $slug): Response
    {
        $transformer = $this->articleDetailsTransformer;
        $article = $this->articleRepository->findOneBySlug($request->getLocale(), $slug);
        $article = $transformer($article);

        return $this->viewHandler->handle($article);
    }
}
