<?php

namespace App\Controller\Portal\Magazine\Article;

use App\Repository\Magazine\Article\ArticleRepository;
use App\Service\Pagination\Context\PaginationContextInterface;
use App\Service\View\Context\ViewContext;
use App\Service\View\ViewHandlerInterface;
use App\Transformer\DTO\Article\ArticleListEntryTransformer;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\RequestStack;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;

#[Route(path: '/magazine/articles', name: 'magazine_article_list', methods: ['GET'])]
class ListController extends AbstractController
{
    public function __construct(
        private readonly ArticleRepository                  $articleRepository,
        private readonly RequestStack                       $requestStack,
        private readonly ArticleListEntryTransformer        $articleListEntryTransformer,
        private readonly ViewHandlerInterface               $viewHandler
    )
    {
    }

    public function __invoke(PaginationContextInterface $paginationContext): Response
    {
        $articles = $this->articleRepository->findPublicArticles(
            $this->requestStack->getCurrentRequest()->getLocale(),
            $paginationContext
        );

        $articles = array_map($this->articleListEntryTransformer, $articles);

        return $this->viewHandler->handle($articles, new ViewContext(extra: [
            'pagination' => $paginationContext
        ]));
    }
}