<?php

declare(strict_types=1);

namespace App\Controller\Portal;

use App\Repository\System\Webspace\ConfigRepository;
use App\Repository\System\Webspace\WebspaceRepository;
use App\Service\View\ViewHandlerInterface;
use App\Transformer\DTO\Shared\ConfigTransformer;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;

#[Route(path: '/', name: 'init', methods: ['GET'])]
final class InitController extends AbstractController
{
    public function __construct(
        private readonly ViewHandlerInterface $viewHandler,
        private readonly ConfigRepository     $configRepository,
        private readonly WebspaceRepository   $webspaceRepository,
        private readonly ConfigTransformer    $configTransformer,
    )
    {
    }

    public function __invoke(Request $request): Response
    {
        $webspace = $this->webspaceRepository->findOneByCode('default');
        $configs = $this->configRepository->findAllByWebspace($request->getLocale(), $webspace->getId());

        $data = [
            'configs' => array_map($this->configTransformer, $configs)
        ];

        return $this->viewHandler->handle($data);
    }
}
