<?php

namespace App\Controller\Portal\Auth\Verification;

use App\Command\Portal\User\VerifyUser as VerifyUserCommand;
use App\DTO\PublicAPI\User\Input\VerifyUser;
use App\Service\Command\CommandBusInterface;
use App\Service\View\ViewHandlerInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpKernel\Attribute\MapRequestPayload;
use Symfony\Component\Routing\Annotation\Route;

#[Route(path: '/auth/verification/verify', name: 'auth_verification_verify', methods: ['POST'])]
class VerifyController extends AbstractController
{
    public function __construct(
        private readonly CommandBusInterface  $commandBus,
        private readonly ViewHandlerInterface $viewHandler
    )
    {
    }

    public function __invoke(#[MapRequestPayload] VerifyUser $verifyUser): Response
    {
        $this->commandBus->handle(new VerifyUserCommand($verifyUser->token));

        return $this->viewHandler->handle([]);
    }
}