<?php

namespace App\Controller\Portal\Auth\Verification;

use App\Command\Portal\User\ResendVerification as ResendVerificationCommand;
use App\DTO\PublicAPI\User\Input\ResendVerification;
use App\Service\Command\CommandBusInterface;
use App\Service\View\ViewHandlerInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpKernel\Attribute\MapRequestPayload;
use Symfony\Component\Routing\Annotation\Route;

#[Route(path: '/auth/verification/resend', name: 'auth_verification_resend', methods: ['POST'])]
class ResendController extends AbstractController
{
    public function __construct(
        private readonly CommandBusInterface  $commandBus,
        private readonly ViewHandlerInterface $viewHandler
    )
    {
    }

    public function __invoke(#[MapRequestPayload] ResendVerification $resendVerification): Response
    {
        $this->commandBus->handle(new ResendVerificationCommand($resendVerification->email));

        return $this->viewHandler->handle([]);
    }
}