<?php

namespace App\Controller\Portal\Auth\PasswordReset;

use App\Command\Portal\User\CheckResetToken;
use App\Service\Command\CommandBusInterface;
use App\Service\View\ViewHandlerInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;

#[Route(path: '/auth/password-reset/check/{token}', name: 'auth_password_reset_check', methods: ['GET'])]
class CheckController extends AbstractController
{
    public function __construct(
        private readonly CommandBusInterface  $commandBus,
        private readonly ViewHandlerInterface $viewHandler
    )
    {
    }

    public function __invoke(string $token): Response
    {
        $this->commandBus->handle(new CheckResetToken($token));

        return $this->viewHandler->handle([]);
    }
}