<?php

namespace App\Controller\Portal\Auth\PasswordReset;

use App\Command\Portal\User\ChangePasswordWithToken as ChangePasswordWithTokenCommand;
use App\DTO\PublicAPI\User\Input\ChangePasswordWithToken;
use App\Service\Command\CommandBusInterface;
use App\Service\View\ViewHandlerInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpKernel\Attribute\MapRequestPayload;
use Symfony\Component\Routing\Annotation\Route;

#[Route(path: '/auth/password-reset/change', name: 'auth_password_reset_change', methods: ['POST'])]
class ChangeController extends AbstractController
{
    public function __construct(
        private readonly CommandBusInterface  $commandBus,
        private readonly ViewHandlerInterface $viewHandler
    )
    {
    }

    public function __invoke(#[MapRequestPayload] ChangePasswordWithToken $requestPasswordChange): Response
    {
        $this->commandBus->handle(new ChangePasswordWithTokenCommand(
            $requestPasswordChange->token,
            $requestPasswordChange->password
        ));

        return $this->viewHandler->handle([]);
    }
}