<?php

declare(strict_types=1);

namespace App\Controller\Cms\System;

use App\Controller\Cms\Abstract\BaseController;
use App\Entity\System\Page\Page;
use App\Form\System\Page\PageType;
use App\Table\System\PageTable;
use App\Traits\Route\CmsAction;
use Symfony\Component\Routing\Annotation\Route;

#[Route('/system/page', name: self::PREFIX)]
final class PageController extends BaseController
{
    use CmsAction;

    final public const KEY = 'pages';

    final public const PREFIX = 'system_page_';

    final public const ENTITY = Page::class;

    final public const FORM = PageType::class;

    final public const TABLE = PageTable::class;
}
