<?php

declare(strict_types=1);

namespace App\Controller\Cms\System;

use App\Controller\Cms\Abstract\BaseController;
use App\Entity\Common\Address;
use App\Form\Common\AddressType;
use App\Table\System\AddressTable;
use App\Traits\Route\CmsAction;
use Symfony\Component\Routing\Annotation\Route;

#[Route('/system/address', name: self::PREFIX)]
final class AddressController extends BaseController
{
    use CmsAction;

    final public const KEY = 'addresses';

    final public const PREFIX = 'system_address_';

    final public const ENTITY = Address::class;

    final public const FORM = AddressType::class;

    final public const TABLE = AddressTable::class;
}
