<?php

declare(strict_types=1);

namespace App\Controller\Cms\Security;

use LogicException;
use Scheb\TwoFactorBundle\Security\TwoFactor\Provider\Email\Generator\CodeGeneratorInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\RedirectResponse;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Component\Security\Core\Authentication\Token\Storage\TokenStorageInterface;
use Symfony\Component\Security\Http\Authentication\AuthenticationUtils;

final class SecurityController extends AbstractController
{
    public function __construct(
        private readonly CodeGeneratorInterface $codeGenerator
    )
    {
    }

    #[Route('/login', name: 'login')]
    public function index(AuthenticationUtils $authenticationUtils): Response
    {
        $authenticationException = $authenticationUtils->getLastAuthenticationError();
        $lastUsername = $authenticationUtils->getLastUsername();

        return $this->render('system/security/login/index.html.twig', [
            'last_username' => $lastUsername,
            'error' => $authenticationException
        ]);
    }

    #[Route('/resend-code', name: 'resend_code')]
    public function resendCode(TokenStorageInterface $tokenStorage): RedirectResponse
    {
        //TODO: TwoFactorInterface a javasolt, de ez alapján működik csak: https://github.com/scheb/two-factor-bundle/issues/284#issuecomment-618536932
        $this->codeGenerator->generateAndSend($tokenStorage->getToken()->getUser());
        return $this->redirectToRoute('cms_2fa_login');
    }

    #[Route('/logout', name: 'logout')]
    public function logout(): never
    {
        throw new LogicException('This method can be blank - it will be intercepted by the logout key on your firewall.');
    }
}
