<?php

declare(strict_types=1);

namespace App\Controller\Cms\Magazine\Article;

use App\Controller\Cms\Abstract\BaseController;
use App\Entity\Magazine\Article\Article;
use App\Form\Magazine\Article\ArticleType;
use App\Table\Magazine\ArticleTable;
use App\Traits\Route\CmsAction;
use Symfony\Component\Routing\Annotation\Route;

#[Route('/magazine/article', name: self::PREFIX)]
final class ArticleController extends BaseController
{
    final public const KEY = 'articles';

    final public const PREFIX = 'magazine_article_';

    final public const ENTITY = Article::class;

    final public const FORM = ArticleType::class;

    final public const TABLE = ArticleTable::class;

    use CmsAction;
}
