<?php

declare(strict_types=1);

namespace App\Controller\Cms\Education;

use App\Controller\Cms\Abstract\BaseController;
use App\Entity\Education\Exam\Exam;
use App\Form\Education\ExamType;
use App\Table\Education\ExamTable;
use App\Traits\Route\CmsAction;
use Symfony\Component\Routing\Annotation\Route;

#[Route('/education/exam', name: self::PREFIX)]
final class ExamController extends BaseController
{
    final public const KEY = 'exams';

    final public const PREFIX = 'education_exam_';

    final public const ENTITY = Exam::class;

    final public const FORM = ExamType::class;

    final public const TABLE = ExamTable::class;

    use CmsAction;
}
