<?php

declare(strict_types=1);

namespace App\Controller\Cms\Education;

use App\Controller\Cms\Abstract\BaseController;
use App\Entity\Education\Apply;
use App\Entity\System\Message;
use App\Form\Education\ApplyType;
use App\Table\Education\ApplyTable;
use App\Traits\Route\CmsAction;
use App\Traits\Route\ListAction;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;

#[Route('/education/apply', name: self::PREFIX)]
final class ApplyController extends BaseController
{
    final public const KEY = 'applies';

    final public const PREFIX = 'education_apply_';

    final public const ENTITY = Apply::class;

    final public const FORM = ApplyType::class;

    final public const TABLE = ApplyTable::class;

    use ListAction;

    #[Route('/{id}/preview', name: 'preview')]
    public function previewAction(Apply $apply): Response
    {
        return $this->render('event/apply_preview.html.twig', [
            'message' => $apply,
            'meta' => ['name' => $this->name, 'route_prefix' => $this->prefix],
        ]);
    }
}
