<?php

namespace App\Components;

use Symfony\Component\HttpFoundation\RequestStack;
use Symfony\UX\LiveComponent\Attribute\AsLiveComponent;
use Symfony\UX\LiveComponent\Attribute\LiveArg;
use Symfony\UX\LiveComponent\Attribute\LiveProp;
use Symfony\UX\LiveComponent\DefaultActionTrait;
use Symfony\UX\LiveComponent\Attribute\LiveAction;
#[AsLiveComponent]
class Cookie
{
    use DefaultActionTrait;

    #[LiveProp(writable: true)]
    public ?bool $isAccepted = null;

    public function __construct(
        private RequestStack $requestStack,
    )
    {
    }

    public function mount(): void
    {
        $this->isAccepted = $this->requestStack->getSession()->get('cookie');
    }

    #[LiveAction]
    public function setCookie(#[LiveArg]  $status): void
    {
        $this->requestStack->getSession()->set('cookie', $status);
        $this->isAccepted = $status;
    }
}
