<?php

declare(strict_types=1);

namespace App\Command\Portal\User;

use App\Repository\User\UserRepository;
use App\Service\Command\CommandBusInterface;
use Symfony\Component\HttpKernel\Exception\BadRequestHttpException;
use Symfony\Component\Messenger\Attribute\AsMessageHandler;
use Throwable;

#[AsMessageHandler(handles: ModifyUser::class, bus: 'command.bus')]
final readonly class ModifyUserHandler
{
    public function __construct(
        private UserRepository      $userRepository,
        private CommandBusInterface $commandBus
    )
    {
    }

    public function __invoke(ModifyUser $modifyUser): void
    {
        $user = $this->userRepository->findById($modifyUser->getId()) ?? throw new BadRequestHttpException();

        $oldFirstName = $user->getFirstName();
        $oldLastName = $user->getLastName();

        $user->setFirstName($modifyUser->getFirstName());
        $user->setLastName($modifyUser->getLastName());

        $password = $modifyUser->getPassword();

        $this->userRepository->add($user, true);

        if (!empty($password)) {
            try {
                $this->commandBus->handle(new ChangeUserPassword($user->getEmail(), $password, true));
            } catch (Throwable) {
                $user->setFirstName($oldFirstName);
                $user->setLastName($oldLastName);
                $this->userRepository->add($user, true);
            }
        }
    }
}
