<?php

declare(strict_types=1);

namespace App\Command\Portal\User;

use App\Service\Command\CommandInterface;

final readonly class ModifyUser implements CommandInterface
{
    public function __construct(
        private string  $id,
        private string  $firstName,
        private string  $lastName,
        private ?string $password
    )
    {
    }

    public function getId(): string
    {
        return $this->id;
    }

    public function getFirstName(): string
    {
        return $this->firstName;
    }

    public function getLastName(): string
    {
        return $this->lastName;
    }

    public function getPassword(): ?string
    {
        return $this->password;
    }
}
