<?php

declare(strict_types=1);

namespace App\Command\Portal\User;

use App\Enum\User\UserDeletionReason;
use App\Service\Command\CommandInterface;

final readonly class DeleteUser implements CommandInterface
{
    public function __construct(
        private string             $id,
        private UserDeletionReason $userDeletionReason,
        private ?string            $otherReason
    )
    {
    }

    public function getId(): string
    {
        return $this->id;
    }

    public function getReason(): UserDeletionReason
    {
        return $this->userDeletionReason;
    }

    public function getOtherReason(): ?string
    {
        return $this->otherReason;
    }
}
