<?php

declare(strict_types=1);

namespace App\Command\Portal\User;

use Symfony\Component\HttpKernel\Exception\BadRequestHttpException;
use Symfony\Component\Messenger\Attribute\AsMessageHandler;
use SymfonyCasts\Bundle\ResetPassword\Exception\ResetPasswordExceptionInterface;
use SymfonyCasts\Bundle\ResetPassword\ResetPasswordHelperInterface;

#[AsMessageHandler(handles: CheckResetToken::class, bus: 'command.bus')]
final readonly class CheckResetTokenHandler
{
    public function __construct(
        private ResetPasswordHelperInterface $resetPasswordHelper
    )
    {
    }

    public function __invoke(CheckResetToken $checkResetToken): void
    {
        try {
            $this->resetPasswordHelper->validateTokenAndFetchUser($checkResetToken->getToken());
        } catch (ResetPasswordExceptionInterface) {
            throw new BadRequestHttpException('Invalid password reset url');
        }
    }
}
