<?php

declare(strict_types=1);

namespace App\Command\Portal\User;

use App\Service\Command\CommandInterface;

final readonly class ChangeUserPassword implements CommandInterface
{
    public function __construct(
        private string $email,
        private string $password,
        private bool   $sendEmail
    )
    {
    }

    public function getEmail(): string
    {
        return $this->email;
    }

    public function getPassword(): string
    {
        return $this->password;
    }

    public function shouldSendEmail(): bool
    {
        return $this->sendEmail;
    }
}
