<?php

declare(strict_types=1);

namespace App\Command\Portal\User;

use App\Service\Command\CommandInterface;

final readonly class ChangePasswordWithToken implements CommandInterface
{
    public function __construct(
        private string $token,
        private string $password
    )
    {
    }

    public function getToken(): string
    {
        return $this->token;
    }

    public function getPassword(): string
    {
        return $this->password;
    }
}
