import {Controller} from '@hotwired/stimulus';
import Uppy from '@uppy/core';
import Dashboard from '@uppy/dashboard';
import ImageEditor from '@uppy/image-editor';
import Tus from '@uppy/tus';
import Hungarian from '@uppy/locales/lib/hu_HU';

import '@uppy/core/dist/style.min.css';
import '@uppy/dashboard/dist/style.min.css';
import '@uppy/image-editor/dist/style.min.css';


export default class extends Controller {

    connect() {
        const
            trigger = document.getElementById(this.element.dataset.trigger),
            input = document.getElementById(this.element.dataset.input),
            preview = document.getElementById(this.element.dataset.preview);

        this.create(trigger, input, preview);
    }

    async create(trigger, input, preview) {
        const tokens = new Map();

        const uppy = new Uppy({
            locale: Hungarian,
        });

        uppy
            .use(Dashboard, {inline: false, trigger: trigger, target: 'body'})
            .use(ImageEditor, {target: Dashboard})
            .use(Tus, {
                endpoint: 'http://upload.simple.localhost/files/',
                allowedMetaFields: null,
                onBeforeRequest: async (req, file) => {
                    if (req.getMethod() === 'POST') {
                        const token = await this.requestAuthToken();
                        tokens.set(file.id, token);
                        req.setHeader('Authorization', token);
                    }
                },
            });


        uppy.on('complete', async (uploadResult) => {
            for (const file of uploadResult.successful) {

                const
                    token = tokens.get(file.id),
                    uploadGrantId = JSON.parse(atob(token.split('.')[1])).sub;

                tokens.delete(file.id);

                const response = await fetch(`http://cms.simple.localhost/upload/check/${uploadGrantId}`, {
                    headers: {'Content-Type': 'application/json'},
                });
                const check = await response.json();

                if (check) {
                    const url = check.data.url;
                    preview.src = url;
                    input.value = url;
                }

            }


        });
    }

    async requestAuthToken() {
        const response = await fetch('http://cms.simple.localhost/cms/hu/upload/sign', {
            headers: {'Content-Type': 'application/json'},
        });
        const responseData = await response.json();
        return responseData.data.token;
    }
}
