import {Controller} from '@hotwired/stimulus';
import EditorJS from '@editorjs/editorjs';
import Header from '@editorjs/header';
import List from '@editorjs/list';
import Embed from '@editorjs/embed';
import Quote from '@editorjs/quote';
import Checklist from '@editorjs/checklist';
import Link from '@editorjs/link';
import LinkAutocomplete from '@editorjs/link-autocomplete';
import AttachesTool from '@editorjs/attaches';
import ImageTool from '@editorjs/image';
import Table from '@editorjs/table';
import Carousel from '@vtchinh/gallery-editorjs/dist/bundle';
export default class extends Controller {
    static values = {apiUrl: String};
    connect() {
        var
            target = this.element.getAttribute('id'),
            textarea = document.getElementById(this.element.getAttribute('data-textarea'));
        this.create(target, textarea);
    }

    create(target, textarea) {
        var data = textarea.value ? JSON.parse(textarea.value) : null;

        const editor = new EditorJS({
            holder: target,
            inlineToolbar: true,

            tools: {
                embed: {
                    class: Embed,
                    inlineToolbar: true
                },
                header: {
                    class: Header,
                    inlineToolbar: true
                },
                table: Table,
                list: {
                    class: List,
                    inlineToolbar: true
                },
                checklist: {
                    class: Checklist,
                    inlineToolbar: true
                },
                link: {
                    class: Link,
                    inlineToolbar: true
                },
                linkAutoComplete: {
                    class: LinkAutocomplete,
                    inlineToolbar: true
                },
                quote: {
                    class: Quote,
                    inlineToolbar: true
                },
                image: {
                    class: ImageTool,

                    config: {

                        endpoints: {
                            byFile: this.apiUrlValue+'/cms/hu/system/file/upload',
                            byUrl: this.apiUrlValue+'/cms/hu/system/file/upload',
                        }
                    }

                },
                attaches: {
                    class: AttachesTool,
                    config: {
                        endpoint: this.apiUrlValue+'/cms/hu/system/file/upload'
                    }
                },
                carousel: {
                    class: Carousel,
                    config: {
                        endpoints: {
                            byFile: this.apiUrlValue+'/cms/hu/system/file/upload',
                            removeImage: "URL_FETCH", //default null
                        },

                        field: 'image',
                        types: 'image/*',
                        additionalRequestData: { // for custom data
                            name: 'your custom data name',
                            order_data: 'your order custom data',
                        },
                        galleryCallback: 'your_prefer_callback_data' // object return is required
                    }
                }
            },
            data: data,
            onChange: (api, event) => {
                editor.save().then((outputData) => {
                    textarea.value = JSON.stringify(outputData);
                }).catch((error) => {
                    console.log('Saving failed: ', error)
                });
            }
        });
    }
}

