import { Controller } from '@hotwired/stimulus';
export default class extends Controller {
    static targets = ["input", "output"]
    static values = { showIf: String }
    connect() {
        this.toggle()
    }

    toggle() {
        this.outputTargets.forEach(outputTarget => {
            outputTarget.style.display = 'none';
            var
                value = this.inputTarget.value,
                groups = JSON.parse(outputTarget.getAttribute('data-form-group'));

            if (groups.includes(value)) {
                outputTarget.style.display = 'block';
            }

        });
    }
}
