import { Controller } from '@hotwired/stimulus';

export default class extends Controller {
    static values = { inactivityTime: Number, logoutPath: String };

    connect() {
        this.maxInactivity = this.inactivityTimeValue * 60;
        this.lastActivity = Date.now();

        this.activityDisplay = document.getElementById('activityDisplay');

        this.updateActivityDisplay();

        setInterval(() => {
            this.updateActivityDisplay();
        }, 1000);

        const activityEvents = [
            'mousedown', 'mousemove', 'keydown',
            'scroll', 'touchstart'
        ];

        activityEvents.forEach(eventName => {
            document.addEventListener(eventName, () => {
                this.lastActivity = Date.now();
            }, true);
        });
    }

    updateActivityDisplay() {
        const secondsSinceLastActivity = Math.floor((Date.now() - this.lastActivity) / 1000);
        let remainingSeconds = this.maxInactivity - secondsSinceLastActivity;
        if (remainingSeconds <= 0) {
            remainingSeconds = 0;
            location.href = this.logoutPathValue;
        }
        this.activityDisplay.innerHTML = this.formatTime(remainingSeconds);
    }

    formatTime(seconds) {
        const minutes = Math.floor(seconds / 60);
        const remainingSeconds = seconds % 60;
        return this.padZero(minutes) + ":" + this.padZero(remainingSeconds);
    }

    padZero(num) {
        return (num < 10 ? '0' : '') + num;
    }
}
