import React, {Component} from 'react';
import SortableTree from 'react-sortable-tree';
import 'react-sortable-tree/style.css';

export default class TreeEditor extends Component {
    constructor(props) {
        super(props);
        const title = 'Hay';
        this.state = {
            searchString: '',
            searchFocusIndex: 0,
            searchFoundCount: null,
            treeData: [],
        };
    }

    componentDidMount() {
        fetch(this.props.apiUrl)
            .then(response => response.json())
            .then(treeData => this.setState({treeData}))
            .catch(error => console.error(error));
    }

    handleTreeChange = ({treeData}) => {
        console.log('A fa frissítve', treeData);
        this.setState({treeData});

        fetch(this.props.apiUrl, {
            method: 'POST',
            body: JSON.stringify(treeData),
        })
            .then(response => response.json())
            .then(data => console.log(data))
            .catch(error => console.error(error));
    };

    handleChange = (treeData) => {
        console.log('A fa megváltozott', treeData);
        this.setState({treeData});
    };

    render() {
        const {searchString, searchFocusIndex, searchFoundCount} = this.state;


        const customSearchMethod = ({node, searchQuery}) =>
            searchQuery &&
            node.title.toLowerCase().indexOf(searchQuery.toLowerCase()) > -1;

        const selectPrevMatch = () =>
            this.setState({
                searchFocusIndex: searchFocusIndex !== null ? (searchFoundCount + searchFocusIndex - 1) % searchFoundCount : searchFoundCount - 1,
            });

        const selectNextMatch = () =>
            this.setState({
                searchFocusIndex: searchFocusIndex !== null ? (searchFocusIndex + 1) % searchFoundCount : 0,
            });

        return (
            <div>
                <div className={'mb-2'}>

                    <form onSubmit={event => {event.preventDefault();}}>

                        <div className={'d-flex w-100 align-items-center justify-content-around'}>

                            <div className={'input-group input-group-merge input-group-solid input-group-sm w-100 border-0'}>
                                <div className={'input-group-prepend input-group-text'}>
                                    <i className={'bi-search'}></i>
                                </div>
                                <input id="find-box" type="text" placeholder="Keresés..." className={'form-control form-control-solid'} value={searchString} onChange={event => this.setState({searchString: event.target.value})}/>
                            </div>

                            <div className={'ms-auto'}>
                                <span className={'badge bg-soft-secondary text-secondary'}>
                                    {searchFoundCount > 0 ? searchFocusIndex + 1 : 0} / {searchFoundCount || 0}
                                </span>
                            </div>

                            <div>
                                <div className={'btn-group ms-1'} role={'group'}>
                                    <button className={'btn btn-white btn-icon btn-xs'} type="button"
                                            disabled={!searchFoundCount} onClick={selectPrevMatch}>
                                        <i className={'bi-chevron-left'}></i>
                                    </button>
                                    <button className={'btn btn-white btn-icon btn-xs'} type="submit"
                                            disabled={!searchFoundCount} onClick={selectNextMatch}>
                                        <i className={'bi-chevron-right'}></i>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
                <div className={'vh-100 px-1'}>
                    <SortableTree
                        treeData={this.state.treeData}
                        onMoveNode={this.handleTreeChange}
                        onChange={this.handleChange}
                        searchMethod={customSearchMethod}
                        searchQuery={searchString}
                        searchFocusOffset={searchFocusIndex}
                        searchFinishCallback={matches =>
                            this.setState({
                                searchFoundCount: matches.length,
                                searchFocusIndex:
                                    matches.length > 0 ? searchFocusIndex % matches.length : 0,
                            })
                        }
                    />
                </div>
            </div>

        );
    }
}
